<?php
function callboac($json)
{
	$url="https://api.businessonacloud.com/Service1.svc/zwl/operator/req/";
	$ch = curl_init($url);                                                                      
	curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");  
	curl_setopt($ch, CURLOPT_POST, true);                                                                   
	curl_setopt($ch, CURLOPT_POSTFIELDS, $json);                                                                  
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);    
	curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 30); 		// 30 second timeout 
	curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 	// in case cURL doesn't recognize the cert                                                         
	curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/raw','Content-Length: '.strlen($json)));                                                                                                                   

	$result = curl_exec($ch);
	curl_close($ch);
	
	return $result;
}

function encode64($st)
{
	$elen=strlen($st);
	$ar=array();
	$mid=intval($elen/2);
	$i=0;
	$chksum=0;
	while ($i<$mid)
	{
		$nch=asc64(substr($st,$i,1));
		if ($nch<0)	return "";
		$ar[$i]=$nch;
		$chksum+=$nch;
		$i++;
	}	
	while ($i<$elen)
	{
		$nch=asc64(substr($st,$i,1));
		if ($nch<0) return "";
		$ar[$i+1]=$nch;
		$chksum+=$nch;
		$i++;
	}
	$chksum=$chksum%64;
	$ar[$mid]=$chksum;
	$ret="";
	for ($i=0; $i<$elen; $i++)
	{
		$fch=$ar[$i];
		$bch=$ar[$i+1];
		$ar[$i]=intval($fch/8)*8+intval($bch/8);
		$ar[$i+1]=($fch%8)*8+($bch%8);
		$ret=$ret.chr64($ar[$i]);
	}
	$ret=$ret.chr64($ar[$elen]);	
	return $ret;
}

function decode64($est)
{
	$elen=strlen($est);
	$ar=array();
	$mid=intval(($elen-1)/2);
	$chksum=0;
	$ar[0]=asc64(substr($est,0,1));
	for ($i=0; $i<$elen-1; $i++)
	{
		$fch=$ar[$i];
		$bch=asc64(substr($est,$i+1,1));
		if (($fch<0) || ($bch<0)) return "";
		$ar[$i]=intval($fch/8)*8+intval($bch/8);
		$ar[$i+1]=($fch%8)*8+($bch%8);
		if ($i!=$mid) $chksum=$chksum+$ar[$i];
	}
	if (($elen-1)!=$mid) $chksum=$chksum+$ar[$elen-1];
	if (($chksum%64)!=$ar[$mid]) return "";
	$ret="";
	for ($i=0; $i<$mid; $i++) $ret=$ret.chr64($ar[$i]);	
	for ($i=$mid+1; $i<$elen; $i++) $ret=$ret.chr64($ar[$i]);	
	return $ret;
}

function asc64($ch)
{
	$nch=ord($ch);
	if (($nch>=48) && ($nch<=57)) return $nch-48;		// 0..9
	if (($nch>=65) && ($nch<=90)) return $nch+10-65;	// A .. Z
	if (($nch>=97) && ($nch<=122)) return $nch+36-97;	// a .. z
	if ($nch==40) return 62;		// (
	if ($nch==41) return 63;		// )
	return -1;
}

function chr64($nch)
{
	if (($nch>=0) && ($nch<=9)) return chr($nch+48);
	if (($nch>=10) && ($nch<=35)) return chr($nch-10+65);
	if (($nch>=36) && ($nch<=61)) return chr($nch-36+97);
	if ($nch==62) return '(';
	if ($nch==63) return ')';
	return "";
}

function hexfrom64($st64)
{
	$i=strlen($st64)-1;
	$ret="";
	while ($i>=1)
	{
		$d1=asc64(substr($st64,$i,1));
		if ($d1<0) return "";				//Invalid leter
		$d2=asc64(substr($st64,$i-1,1));
		if ($d2<0) return "";				// Invalid leter
		$ret=hexc(intval($d2/4)).hexc(($d2%4)*4+intval($d1/16)).hexc($d1%16).$ret;
		$i=$i-2;
	} 
	if ($i==0)
	{
		$d1=asc64(substr($st64,$i,1));
		if ($d1<0) return "";		// Invalid leter
		$ret=hexc(intval($d1/16)).hexc($d1%16).$ret;
	}
	$pos=strpos($ret,'F');
	return substr($ret,$pos+1);
}

function decfrom64($st64)	// Return integer
{
	$ret=0;
	for ($i=0; $i<strlen($st64); $i++)
	{
		$ret=$ret*64+asc64(substr($st64,$i,1));
		if ($ret>999999999999999) return -1;
	}
	return $ret;
}

function cadd($cdec,$num)
{
	$ret="";
	$i=strlen($cdec)-1;
	$p=$num;
	while ($i>=0)
	{
		$nch=ord(substr($cdec,$i,1))-48;
		if (($nch<0) || ($nch>9)) return "";
		$p=$nch+$p;
		$ret=chr($p%10+48).$ret;
		$p=intval($p/10);
		$i=$i-1;
	}	 	
	if ($p>0) $ret="".$p.$ret;
	$ret=ltrim($ret,'0');
	if (strlen($ret)==0) $ret='0';	
	return $ret;
}

function cmul($cdec,$num)
{
	$ret="";
	$i=strlen($cdec)-1;
	$p=0;
	while ($i>=0)
	{
		$nch=ord(substr($cdec,$i,1))-48;
		if (($nch<0) || ($nch>9)) return "";
		$p=$nch*$num+$p;
		$ret=chr($p%10+48).$ret;
		$p=intval($p/10);
		$i=$i-1;
	}	 	
	if ($p>0) $ret="".$p.$ret;
	$ret=ltrim($ret,'0');
	if (strlen($ret)==0) $ret='0'; 	
	return $ret;
} 		

function charfrom64($st64)
{
	$i=strlen($st64)-1;
	$ret="";
	while ($i>=3)
	{
		$p=substr($st64,$i-3,4);
		$dec=decfrom64($p);
		$ret=chr($dec%256).$ret;
		$dec=intval($dec/256);
		$ret=chr($dec%256).$ret;
		$dec=intval($dec/256);
		$ret=chr($dec%256).$ret;
		$i=$i-4;
	}	

	if ($i>=0)
	{
		$p=substr($st64,0,$i+1);
		$dec=decfrom64($p);
		while ($dec>0)
		{
			$ret=chr($dec%256).$ret;
			$dec=intval($dec/256);
		}
	}	
	return $ret;	
}

function cdecfrom64($st64)
{
	$ret="0";
	for ($i=0; $i < strlen($st64); $i++) $ret=cadd(cmul($ret,64),asc64(substr($st64,$i,1)));
	return $ret;
}

function inc64($st64)
{
	$i=strlen($st64)-1;
	$ret="";
	$nch=asc64(substr($st64,$i,1))+1;
	while (($i>=0)&&($nch==64))
	{
		$ret='0'.$ret;
		$i=$i-1;
		if ($i>=0) $nch=asc64(substr($st64,$i,1))+1;	
	}
	if ($i>=0)
	{
		 $ret=chr64($nch).$ret;
		 $ret=substr($st64,0,$i).$ret;
	}	 
	else if ($nch==64) $ret='1'.$ret;
	return $ret;
}

function gencard_old($order)
{
	$chk=0;
	$x=0+$order;
	while ($x!=0)
	{
		$chk+=$x%10;
		$x=intval($x/10);
	}	
	srand((double)microtime()*1000000);
 	$x=rand(1,9999); 
 	$ret=substr(10000+$x,1,4);
 	while ($x!=0)
	{
		$chk+=$x%10;
		$x=intval($x/10);
	}
	$chk=$chk%100;
	$ret.=substr(100+$chk,1,2).substr(100000+$order,1,5);
	return $ret;
}

function gencard($order,$group)
{
	if ($order>9999) return "";
	if ($group>99) return "";
	$x=$order;
	//seg=(x*x*x+987659*x+812) % 100000
	$seg=(($x*$x % 100000)*$x % 100000+(87659*$x % 100000)+812) % 100000;
	$ret=substr(1000000+$seg,1,5).substr(100+$group,1,2).substr(10000+$order,1,4);
	return $ret;
}

function upc($upcode)
{
	/*
	* Identify the standard UPC barcode
	* Return 12 digital standard UPC if the code is legal
	* else return ""
	*/
	
	$ucode=trim($upcode);
	if (strlen($ucode)<10) return "";

	if (strlen($ucode)==10) $ucode='0'.$ucode; 	
	
	$po=0;
	$pe=0;
	for ($i=0;$i<9;)
	{
		$po=$po+ord(substr($ucode,$i,1))-48;
		$pe=$pe+ord(substr($ucode,$i+1,1))-48;
		$i+=2;
	} 	
	$po=$po+ord(substr($ucode,10,1))-48;
	
	if (strlen($ucode)==11)
	{
		$ucode=$ucode.chr((10-($po*3+$pe)%10)%10+48);
		return $ucode;
	}	 	
	else if (strlen($ucode)>11)
	{
		if ((10-(po*3+pe)%10)%10==ord(substr($ucode,11,1))-48) return $ucode;
	}
	return "";
}

function magstr($card)
{
	$ncard=0+$card;
	$ret=cmul($card,$ncard);	//x^2
	$ret=cadd($ret,416627);		//x^2+416627
	$ret=cmul($ret,$ncard);		//x*(x^2+416627)
	$ret=cadd($ret,5318);		//x*(x^2+416627)+5318
	
	$ret.=$card.date("YmdHis");
	return $ret;
}	
?>










